// Poseball script for both pose balls
// Author: Ferd Frederix

integer debug = 0;

integer regionchannel = -333;

Debug(string msg)
{
    if (debug)
        llOwnerSay(msg);
}

integer iPlayChannel = 2;
string current;

string ahold = "hold_rod";
string aflick  = "rod_flick";
string acast  = "rod_cast";
string areel = "reel_in_ani";   // !!! need reel in animation

string cast_sound = "cast_sound";
string reel_in_sound = "reel_in";

// nibbles
string nibble_sound1 = "reel1_sound";
string nibble_sound2 = "reel2_sound";
string nibble_sound3 = "reel3_sound";
string nibble_sound4 = "nibble_sound";

integer worn = FALSE;
 
integer fishing = 0;

sound(string snd)
{
    llTriggerSound(snd,1.0);
}

animate(string ani)
{
    llStopAnimation(current);
    Debug("start:" + ani);
    llStartAnimation(ani); 
    current = ani;
}

castrod()
{
    animate(ahold); 
    llSleep(1.0);
    sound (cast_sound);
    animate(acast);
    llSleep(5.0);
    animate (ahold);
    fishing = TRUE;
    llSetTimerEvent(20+ llFrand(10));
}

reel_in()
{
    fishing = FALSE;
    animate(areel);
    sound(reel_in_sound);
    llSleep(10);
    animate(ahold);
}

reel_in_and_cast()
{
    fishing = FALSE;
    Debug("reel in and cast");
    reel_in();
    castrod();
    fishing = TRUE;
}

catch()
{
    fishing = FALSE;
    Debug("catch");
    llSay(0, "You hooked something!");
    reel_in();
    if (llFrand(2) < 1)
    {
        llSay(0, "You caught something!");
        llRegionSay(regionchannel,(string) llGetOwner());
    }   
    else
        llSay(0, "You lost it!");
        
    animate(ahold);
    fishing = FALSE;
}

nibble_sound()
{
    float s = llFrand(4);
    Debug("sound:" + (string) s);
    if (s < 1)
        sound (nibble_sound1);
    else if (s <2)
        sound (nibble_sound2);
    else if (s <3)
        sound (nibble_sound2);
    else 
        sound (nibble_sound3);
        llSleep(1.0);
        
}
nibble()
{
    Debug("nibble");
    animate(aflick);
    nibble_sound();
    
    animate(ahold);
}
miss()
{
    fishing = FALSE;
    Debug("miss");
    nibble_sound();
    animate(aflick);
    llSleep(1.0);
    llSay(0,"Something took your bait");
    reel_in();
}


default
{
    
   
    
    state_entry()
    {
        if (debug)
            llRequestPermissions(llGetOwner(), PERMISSION_TRIGGER_ANIMATION);
    }

    attach( key id)
    {
        //llOwnerSay("attached to" +  (string) id);
            if (id != NULL_KEY) //evaluated as true if not NULL_KEY or invalid
            {
                llRequestPermissions(id, PERMISSION_TRIGGER_ANIMATION);
            }
            else
            {
                worn = FALSE;
            }

    }


    run_time_permissions(integer perm)
    {
        if(PERMISSION_TRIGGER_ANIMATION & perm)
        {
            current = "stand";
            llSay(0,"Touch your rod to cast, or type 'cast'");
            animate(ahold);    // you can choose a different animation for sitting
            worn = TRUE;
            llListen(0,"",llGetOwner(),"");   
        }
    }
    
    timer()
    {
        
        if (!fishing)
        {
            llSetTimerEvent(0);
            return;
        }
        
        integer chance = llCeil( llFrand(6.0));
        Debug("chance="+ (string) chance);
         
        if (chance  <3 )
        {
            catch();
        }
        else  if (chance <4)
        {
            nibble();
        }
        else
        {
            miss();
        }
    }

    listen(integer channel,string name,key id, string msg)
    {
        if (msg == "cast" && fishing)
            reel_in_and_cast();
        else if (msg == "cast" && ! fishing)
            castrod();
        
        if (debug)
        {
            if (msg == "catch")
                catch();
                    
            if (msg == "nibble")
                nibble();
                
            if (msg == "miss")
                miss();
        }    
    }
    touch_start(integer touched)
    {
        if (llDetectedKey(0) == llGetOwner())
        {
            if (! fishing)
                castrod();
                
            else 
                reel_in_and_cast();
        }
    }
}
