//====================================================================================
// Super Hottub 1.1       --    Siggy Romulus  --  Get_Toe() Scripts
//------------------------------------------------------------------------------------
// New Features :    - Starts with water rezzed
//                   - Water 'follows' tub when it's moved, no more HOTTUB RESET
//                   - Buttons 'flash' and recolor to show their settings
//                   - Variable steam settings
//                   - Bubble Jets with nifty bubblesounds.
//                   - Voice commands only from owner
//                   - Code tidy up, 1.3 friendly, little more streamlined.
//=====================================================================================
// Variables
//-------------------------------------------------------------------------------------

integer WATER_CHANNEL = 50;             // Chat channel for water to listen to commands
string  WATER_NAME = "Water-1.07";       // Name of the water object       
vector WATER_POS;                       // Waters start position
rotation WATER_ROT;                     // Waters start rotation
//======================================================================================
// Functions
//--------------------------------------------------------------------------------------

Init_Water()                                    // To Rez Water or to Reset it
{
    llSay(WATER_CHANNEL,"WATER DIE");           // Kill any Water we have running
    
    WATER_POS = llGetPos();                     // Fetch the tubs coords and calculate
    WATER_POS.z = WATER_POS.z + .01;            // Water start position and rotation
    WATER_ROT = llGetRot();  
                                                // Finally, rez the water    
    llRezObject(WATER_NAME, WATER_POS, ZERO_VECTOR, WATER_ROT, 0);  
}
//=======================================================================================
// States
//---------------------------------------------------------------------------------------
default
{
    state_entry()
    {
        string Owner;
        key OwnerKey;
        
        OwnerKey = llGetOwner();                // Fetch the owners key  
        Owner = llKey2Name(OwnerKey);          // Work out their name
        
        Init_Water();                           // Rez the water object
        
        llListen(0, Owner , "", "");            // Listen for owner commands
    }
    
    on_rez( integer start_param)                // Setup Water when we rez
    {
        string Owner;                           // Do I really need to do all this twice?
        key OwnerKey;                           // Better safe than sorry I suppose
        
        OwnerKey = llGetOwner();
        Owner = llKey2Name(OwnerKey);        
        
        Init_Water();                           // Initialize the water object
        
          llListen(0, Owner, "", "");  
    }
    
    moving_end()                                // When the hottub is moved, we want to
    {                                           // 'move' the water into it -- killing the
        Init_Water();                           // old and rezzing again is a simple way
    }                                           // but not terribly elegant.
    
    listen(integer channel, string name, key id, string msg)
    {
        if (msg == "HOTTUB RESET")              // Left in for backwards compatability only
        {
            Init_Water();
        }
        
    }
}
