default
{
    state_entry()
    {        
        llVolumeDetect(TRUE);
        llSetTimerEvent(30.0 - llFrand(25.0)); // Pick a random number between 5 and 30.
                                                // Use that as number of seconds.
                                                //  Start a timer for that many seconds.
    }
    on_rez(integer start_param)
    {
        llResetScript(); //Reset the script when we rez the object.
    }
    
    timer()
    {
        integer RandomNumber; // We need a whole number here, so we'll tell the script, 'We're gonna grab a whole number and call it this'.
        RandomNumber = (integer)llFrand(llGetInventoryNumber(INVENTORY_SOUND)); // Count how many sounds are in inventory.
                                                                                // Turn that into our random whole number.
        if (llGetInventoryNumber(INVENTORY_SOUND)>0) // If there are any sounds in inventory, do the next bit.  If not, do nothing.
        {
            float volume = llFrand(1.0); // Pick a random non-whole number between 0.0 and 0.6
                                        // Use that for the volume.
            llPlaySound(llGetInventoryName(INVENTORY_SOUND, RandomNumber), volume); // Even though scripts start counting at 0 instead of 1, we don't need to subtract 1 from our number, because telling it to be an integer earlier took care of that (somehow).
                                                                                        // Play that number sound, at the right volume.
            state next; // Go to the next state, so we can get fresh random numbers.
        }
    }
}

state next
{
    state_entry()
    {
        state default; // Once the script gets here, go back to Default and start all over, because we don't want to have to copy everything again.
    }
}

