//======================================================================
// Super Hottub Water Switch   -- changes color with water level
//======================================================================
// Variables
//----------------------------------------------------------------------

integer HOTTUB_CHANNEL = 50;             // Commmand channel for hottub
//======================================================================
// States
//----------------------------------------------------------------------
default
{
    state_entry()
    {
        llSetColor(<0.0, 0.2, 0.5>, ALL_SIDES);     // Set Dim color 
        
        llListen(HOTTUB_CHANNEL, "", "", "");       // Listen for commands

    }

    listen(integer channel, string name, key id, string msg)
    {
        if (msg == "WATER ON")
        {
            llSetColor(<0.0, 0.2, 1.0>, ALL_SIDES);     // Light up the switch
        }
        else if (msg == "WATER OFF")
        {
            llSetColor(<0.0, 0.2, .5>, ALL_SIDES);      // Dim the switch            
        }
        
        
    }

    touch_start(integer total_number)
    {
        llSetColor(<0.0, 0.5, 1.0>, ALL_SIDES);     // Flash color to show seleced 
        llSay(HOTTUB_CHANNEL, "LEVEL");             // Command to change water level 
    }

}
