//=========================================================================
// Super Hottub Steam Switch -- changes color when hit
//=========================================================================
// Variables
//-------------------------------------------------------------------------
integer HOTTUB_CHANNEL = 50;


//=========================================================================
// States
//-------------------------------------------------------------------------

default 
{
    state_entry()
    {
        llSetColor(<0.2, 0.0, 0.0>, ALL_SIDES);     // Set to 'off' color;
        llListen(HOTTUB_CHANNEL, "", "", "");
    }

    touch_start(integer total_number)
    {
        llSetColor(<1.0, 0.0, 0.0>, ALL_SIDES);     // 'Flash' color
        llSay(HOTTUB_CHANNEL, "STEAM");
    }

    listen(integer channel, string name, key id, string msg)
    {
        if (msg == "STEAM LEVEL 0")
        {
            llSetColor(<0.2, 0.0, 0.0>, ALL_SIDES);     // Set to 'off' color 
        }
        else if (msg == "STEAM LEVEL 1")
        {
            llSetColor(<0.4, 0.0, 0.0>, ALL_SIDES);     // Set to level 1 color
        }
        else if (msg == "STEAM LEVEL 2")                
        {
            llSetColor(<0.6, 0.0, 0.0>, ALL_SIDES);     // Set to level 2 color    
        }
        else if (msg == "STEAM LEVEL 3")
        {
            llSetColor(<0.8, 0.0, 0.0>, ALL_SIDES);     // Set to level 3 color   
        }
    }
}
