//*******************************************************
// Shin Ingen @ Modified By Joe Builder
// LSL | OPENSIM | BulletSim | MOTO v2.0
// iTEC + e3s + DC (ENGINE SPEED SENSITIVE STEERING WITH DYNAMIC CAMERA)
// JANUARY 28, 2013
// TODO: KEYWORD PROCESSOR FOR ** PRIM ANIMATION | AVATAR ANIMATION | SOUNDS | MENU | HUD | DYNAMIC CAMERA
//*******************************************************

//---PERMISSION VARIABLES---------------------------------------------
integer         gDrivePermit = 0; // 0=EVERYONE 1=OWNERONLY
string          gSitMessage = "Drive";
string          gUrNotAllowedMessage = "Vehicle is Locked";
vector          gSitTarget_Pos = <0.6,0.0,0.25>;
vector          gSitTarget_Rot;
key             gOldAgent;
key             gAgent;
integer         gRun;     //ENGINE RUNNING
integer         gMoving;  //VEHICLE MOVING
//integer        gIdle;
//---END PREMISSION----------------------------------------------------
 
//---ANIMATION VARIABLES-----------------------------------------------
string      gDrivingAnim = "jet ski";
string      gDrivingSlowLeftTurnAnim = "jet ski";
string      gDrivingSlowRightTurnAnim = "jet ski";
string      gDrivingFastLeftTurnAnim = "jet ski";
string      gDrivingFastRightTurnAnim = "jet ski";
string      gCurrentAnim;
//---------------------------------------------------------------------

//---CAMERA VARIABLES--------------------------------------------------
//***CONSTANT**********************************************************
integer         gCamFixed=0;             // INITVAL=0            0=FOLLOW CAM 1=FIXED CAM
//integer       gCamAct;                // INITVAL=1            0=INACTIVE  1=ACTIVE
//integer       gCamFocLocked;          // INITVAL=FALSE        (TRUE or FALSE)
//integer       gCamPoslocked;          // INITVAL=FALSE        (TRUE or FALSE)
//***SLIDERS***********************************************************
//float         gCamBAng;               // INITVAL=2.0            (0 to 180) DEGREES
//float         gCamBLag;               // INITVAL=0.1            (0 to 3) SECONDS
//float         gCamDist;               // INITVAL=8.0            (0.5 to 10) METERS
//float         gCamFocLag;             // INITVAL=0.1            (0 to 3) SECONDS
//float         gCamFocThresh;          // INITVAL=0.5            (0 to 4) METERS
//float         gCamPitch;              // INITVAL=20.0           (-45 to 80) DEGREES
//float         gCamPoslag;             // INITVAL=0.1            (0 to 3) SECONDS
//float         gCamPosthresh;          // INITVAL=0.5            (0 to 4) METERS
//vector        gCamFocOff;             // INITVAL=<0.10,0,0>     <-10,-10,-10> to <10,10,10> METERS
//----END CAMERA-------------------------------------------------------

//---SOUND VARIABLES---------------------------------------------------
string       gSoundFlight =          "s_flight";
string       gSoundHorn =            "s_horn";
string       gSoundStartup =         "Ducati-start2";
string       gSoundIdle =            "Ducati-idle2";
string       gSoundSlow =            "Ducati-run";
string       gSoundAggressive =      "Ducati-runfast";
string       gSoundGearUp =          "Ducati-accelerate";
string       gSoundGearDown =        "Ducati-accelerate";
string       gSoundRev =             "s_rev";
string       gSoundAlarm =           "s_alarm";
string       gSoundStop =            "Ducati-off";
//NEED KEYWORD SOUND PROCESSOR
integer      gOldSound=3;   //variable for sound function
integer      gNewSound=3;
//---------------------------------------------------------------------

//---iTEC - STOCK MOTO ENGINE GLOBAL VARIABLES-------------------------
list        gTSvarList;
float       gVLMT;  
float       gVLMDT; 
vector      gVLFT;
vector      gVAFT;
float       gVADE;
float       gVADT;
float       gVAMT; 
float       gVAMDT;
float       gVLDE;
float       gVLDT;
float       gVVAE;
float       gVVAT;
float       gVHE;
float       gVHT;
float       gVHH;
float       gVB;
float       gVBE;
float       gVBM;
float       gVBT;
float       gVerticalThrust;
//---------------------------------------------------------------------
 
//---iTEC POWERTRAIN + (e3s) GLOBAL VARIABLES -------------------------
integer        gGear;
integer         gNewGear;
float           gGearPower;
float           gReversePower        = -15;
list            gGearPowerList;
//integer     gGearCount;
//string      gPhysEngDesc;
integer         gPhysEngStep        =  1; // 0= BulletSim 11/1 step| 1=BulletSim 20/1 step (default for ingen-lab)
float           gTurnMulti        =  1.012345;

float        gMaxLean            = 1.4; // how close you want to lick the pavement max@90
float           gTurnRatio;
list            gTurnRatioList;

float           gAngularXratio;
list            gAngularXratioList;

float           gAngularYratio;
list            gAngularYratioList;
float           gAngularZratio;

list            gAngularZratioList;

string          gGearName;
list            gGearNameList        =[   
                                 "CREEP",
                                 "SLOW",
                                 "1ST-GEAR",
                                 "2ND-GEAR",
                                 "3RD-GEAR",
                                 "4TH-GEAR",
                                 "5TH-GEAR",
                                 "6TH-GEAR",
                                 "7TH-GEAR",
                                 "8TH-GEAR",
                                 "9TH-GEAR",
                                 "10TH-GEAR"
                            ];
float         gSpeed            =0;
//---------------------------------------------------------------------

//---------------------------------------------------------------------
//NEED A KEYWORD PRIM ANIMATION PROCESSOR
integer            gTurnCount;
string           gTurnAngle =               "NoTurn";  // LeftTurn or RightTurn or NoTurn
string           gNewTurnAngle =            "NoTurn";
string           gTireSpin =                "ForwardSpin";   // ForwardSpin or BackwardSpin or NoSpin
string           gNewTireSpin =             "ForwardSpin";
string           gRotorSpin =               "NoRotate";         // NoRotate or SlowRotate or FastRotate
integer          gTcountL; //for cornerFX
integer          gTcountR;

//---------------------------------------------------------------------

//---MENU HANDLER------------------------------------------------------
list                MENU_MAIN = ["Align", "PE-Default", "PE-iTEC"]; // up to 12 items in list
integer             menu_handler;
integer             menu_channel;
//---------------------------------------------------------------------
float                gVelmulti        =2.23692912;    //MPH=02.23692912  //KmPH=01.631
vector               gFacecolor        =<1.0,1.0,1.0>; //WHITE

//=======================================================================
//==== E N D   G L O B A L   V A R I A B L E   D E C L A R A T I O N ====
//=======================================================================
init_TSvar(integer i){
    if (i==0){
        gTSvarList = [  
                        0.60,                   // 0 
                        0.10,                   // 1 
                        <10.0,10.0,1000.0>,       //  2 
                        <1.0,1.0,1000.0>,         //  3 
                        0.20,                   //  4 
                        0.10,                   //  5 
                        0.10,                   //  6 
                        10.0,                   //  7
                        0.10,                   //  8
                        10.0,                   //  9
                        3.00,                   //  10
                        2.00,                   //  11

                        0.0,                    //  12
                        0.0,                    //  13
                        0.0,                    //  14
                        0.0,                    //  15

                        1.0,                    //  16
                        1.0,                    //  17
                        0.50                    //  18
                     ];
    }else{
        gTSvarList = [  
                        0.60,                   // 0 
                        0.10,                   // 1 
                        <10.0,10.0,1000.0>,       //  2 
                        <1.0,1.0,1000.0>,         //  3 
                        0.20,                   //  4 
                        0.10,                   //  5 
                        0.10,                   //  6 
                        10.0,                   //  7
                        0.10,                   //  8
                        10.0,                   //  9
                        3.00,                   //  10
                        2.00,                   //  11

                        0.0,                    //  12
                        0.0,                    //  13
                        0.0,                    //  14
                        0.0,                    //  15

                        1.0,                    //  16
                        1.0,                    //  17
                        0.50                    //  18
                    ];
    }
    gVLMT=llList2Float(gTSvarList,0);
    gVLMDT=llList2Float(gTSvarList,1);
    gVLFT=llList2Vector(gTSvarList,2);
    gVAFT=llList2Vector(gTSvarList,3);
    gVAMT=llList2Float(gTSvarList,4);
    gVAMDT=llList2Float(gTSvarList,5);
    gVLDE=llList2Float(gTSvarList,6);
    gVLDT=llList2Float(gTSvarList,7);
    gVADE=llList2Float(gTSvarList,8);
    gVADT=llList2Float(gTSvarList,9);
    gVVAE=llList2Float(gTSvarList,10);
    gVVAT=llList2Float(gTSvarList,11);
    gVHE=llList2Float(gTSvarList,12);
    gVHT=llList2Float(gTSvarList,13);
    gVHH=llList2Float(gTSvarList,14);
    gVB=llList2Float(gTSvarList,15);
    gVBE=llList2Float(gTSvarList,16);
    gVBM=llList2Float(gTSvarList,17);
    gVBT=llList2Float(gTSvarList,18);

}

init_PhysEng(){
    string msg;

  
    
    if(gPhysEngStep==0){
        gTurnMulti=gTurnMulti;
        init_TSvar(0);

        gTurnRatioList     = [0.500000,0.750000,2.715151,3.810101,4.010101,6.010101,6.010101,6.010101,6.010101,6.010101,6.010101,6.010101];

        gAngularXratioList = [0.3932,0.5898,1.9811,2.4466,3.3789,5.064,5.0725,5.0811,5.0896,5.1066,5.1151];
        gAngularYratioList = [0.0,0.0,0.0,1.5,0.0,0.0,0.0,0.0,0.0,0.0,0.0];
        gAngularZratioList = [0.5617,0.8426,2.8302,3.4952,1.5808,1.688,1.6908,1.6937,1.6965,1.7022,1.705];

        gGearPowerList     = [2,15,30,40,50,60,70,80,90,100,110,256];
    
    }else{
        gTurnMulti=1.12345;
        init_TSvar(1);

        gTurnRatioList     = [0.500000,0.750000,2.715151,3.810101,4.010101,6.010101,6.010101,6.010101,6.010101,6.010101,6.010101,6.010101];

        gAngularXratioList = [0.3932,0.5898,1.9811,2.4466,3.3789,5.064,5.0725,5.0811,5.0896,5.1066,5.1151];
        gAngularYratioList = [0.0,0.0,0.0,1.5,0.0,0.0,0.0,0.0,0.0,0.0,0.0];
        gAngularZratioList = [0.5617,0.8426,2.8302,3.4952,1.5808,1.688,1.6908,1.6937,1.6965,1.7022,1.705];

        gGearPowerList     = [2,15,30,40,50,60,70,80,90,100,110,256];

    }
        llSay(0,msg);
}

preload_sounds(){
    llPreloadSound(gSoundFlight);
    llPreloadSound(gSoundHorn);
    llPreloadSound(gSoundStartup);
    llPreloadSound(gSoundIdle);
    llPreloadSound(gSoundSlow);
    llPreloadSound(gSoundAggressive);
    llPreloadSound(gSoundGearUp);
    llPreloadSound(gSoundGearDown);
    llPreloadSound(gSoundRev);
    llPreloadSound(gSoundAlarm);
}

init_engine(){
    gRun = 0;
    llSetSitText(gSitMessage);
    llCollisionSound("", 0.0);
    gSitTarget_Rot = llRot2Euler( llGetRootRotation() ); // SIT TARGET IS BASED ON VEHICLE'S ROTATION.
    llSitTarget(gSitTarget_Pos, llEuler2Rot(DEG_TO_RAD * gSitTarget_Rot));
    gOldSound=3; 
    gNewSound=3;
    gTireSpin = "NoSpin";
    gTurnAngle = "NoTurn";
    gRotorSpin = "NoRotate";
    llSetLinkPrimitiveParamsFast(LINK_ALL_CHILDREN, [PRIM_PHYSICS_SHAPE_TYPE, PRIM_PHYSICS_SHAPE_NONE]);
    llMessageLinked(LINK_SET, 0, gTireSpin, NULL_KEY);      // NO SPIN
    llMessageLinked(LINK_SET, 0, gTurnAngle, NULL_KEY);     // NO TURN
    llMessageLinked(LINK_SET, 0, gRotorSpin, NULL_KEY);     // SLOW SPIN
}

init_followCam(){
    llSetCameraParams([
                       CAMERA_ACTIVE, 1,                 // 0=INACTIVE  1=ACTIVE
                       CAMERA_BEHINDNESS_ANGLE, 20,     // (0 to 180) DEGREES
                       CAMERA_BEHINDNESS_LAG, 0.0,       // (0 to 3) SECONDS
                       CAMERA_DISTANCE, 20,             // ( 0.5 to 10) METERS
                       CAMERA_PITCH, 12.0,                // (-45 to 80) DEGREES
                       CAMERA_POSITION_LOCKED, FALSE,    // (TRUE or FALSE)
                       CAMERA_POSITION_LAG, 0.0,         // (0 to 3) SECONDS
                       CAMERA_POSITION_THRESHOLD, 0.0,   // (0 to 4) METERS
                       CAMERA_FOCUS_LOCKED, FALSE,       // (TRUE or FALSE)
                       CAMERA_FOCUS_LAG, 0.0,           // (0 to 3) SECONDS
                       CAMERA_FOCUS_THRESHOLD, 0.0,      // (0 to 4) METERS
                       CAMERA_FOCUS_OFFSET, <0.0,0,0>   // <-10,-10,-10> to <10,10,10> METERS
                      ]);
                      llForceMouselook(FALSE);
}

init_fixedCam(float degrees) {
    rotation sitRot = llAxisAngle2Rot(<0, 0, 1>, degrees * PI);
    llSetCameraEyeOffset(<-10, 0, 3.5> * sitRot);
    llSetCameraAtOffset(<4, 0, 3> * sitRot);
    llForceMouselook(FALSE);
}

set_engine(){
    integer vfW = VEHICLE_FLAG_HOVER_WATER_ONLY | VEHICLE_FLAG_HOVER_TERRAIN_ONLY | VEHICLE_FLAG_HOVER_GLOBAL_HEIGHT;
    integer vfG = VEHICLE_FLAG_NO_DEFLECTION_UP | VEHICLE_FLAG_LIMIT_ROLL_ONLY | VEHICLE_FLAG_HOVER_UP_ONLY |
        VEHICLE_FLAG_LIMIT_MOTOR_UP;
    integer vfA = VEHICLE_FLAG_HOVER_GLOBAL_HEIGHT;
    llSetVehicleType(VEHICLE_TYPE_BOAT);
    llSetVehicleRotationParam(VEHICLE_REFERENCE_FRAME, <0.00000, 0.00000, 0.00000, 0.00000>);
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 4.5);
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_DECAY_TIMESCALE, 0.2);
    llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <4.0, 4.0, 4.0>);
    llSetVehicleVectorParam(VEHICLE_ANGULAR_FRICTION_TIMESCALE, <1.0, 1.0, 1.0>);
    llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_TIMESCALE, 0.2);
    llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_DECAY_TIMESCALE, 0.5);
    llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_EFFICIENCY, 1.0);
    llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_TIMESCALE, 1.0);
    llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_EFFICIENCY, 1.0);
    llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_TIMESCALE, 3.0);
    llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_EFFICIENCY, 1.0);
    llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_TIMESCALE, 1.0);
    llSetVehicleFloatParam(VEHICLE_HOVER_EFFICIENCY, gVHE );
    llSetVehicleFloatParam(VEHICLE_HOVER_TIMESCALE, gVHT );
    llSetVehicleFloatParam(VEHICLE_HOVER_HEIGHT, 1 );
    llSetVehicleFloatParam(VEHICLE_BUOYANCY, 3.0 );
    llSetVehicleFloatParam( VEHICLE_BANKING_EFFICIENCY, 0.8);
    llSetVehicleFloatParam( VEHICLE_BANKING_MIX, 0.8);
    llSetVehicleFloatParam( VEHICLE_BANKING_TIMESCALE, 0.8);

   // llRemoveVehicleFlags(vfW);
   // llRemoveVehicleFlags(vfA);
   // llSetVehicleFlags(vfG);
   
    gRotorSpin = "SlowRotate";
    llMessageLinked(LINK_SET, 0, gRotorSpin, NULL_KEY);     // SLOW SPIN
    llMessageLinked(LINK_SET, 0, "pipeflame_steady", NULL_KEY);
}

powershift(integer g){
    if(!gMoving){
        if(gCamFixed==0){
        }
    }
    else {
    vector vel = llGetVel();
    float speed = llVecMag(vel);
    if (speed <=20){
         if(gCamFixed==0){
            }
        }
        else if ((speed >=21) || (speed <=50)){
            if(gCamFixed==0){    
            }
        }
        else  if (speed >=51) {
             if(gCamFixed==0){   
            }
        
        }
    }
    gGearPower = llList2Integer(gGearPowerList, g);
}

gearshift(integer g){
    gGearName = llList2String(gGearNameList, g);
    enginesound();
    llSay(0,gGearName);
}

nearestpi(){
    // ALIGNS THE VEHICLE EAST WEST SOUTH NORTH BASED ON CURRENT ROTATION (PRESTAGE AND STAGE DURING DRAG MODE)    
    vector Rad = llRot2Euler( llGetRootRotation() );
    llSetRot( llEuler2Rot( <Rad.x, Rad.y, llRound( Rad.z / PI_BY_TWO ) * PI_BY_TWO > ) );
}

menu(key user,string title,list buttons)
{
    llListenRemove(menu_handler);
    menu_channel = (integer)(llFrand(99999.0) * -1);
    menu_handler = llListen(menu_channel,"","","");
    llDialog(user,title,buttons,menu_channel);
    llSetTimerEvent(30.0); 
}

showdata(string s){
    //llSetText(s+"\n.\n.\n.\n.",<1,1,.6>,1.0);
    //llSetText("",<0,0,0>,1.0);
}

enginesound(){
    vector vel = llGetVel();
    float speed = llVecMag(vel);
    if (speed <=10){
        gNewSound = 0;
        }
        else if (speed >=50){
            gNewSound = 2;
        }
        else {
            gNewSound = 1;
        }
        
    if (gOldSound != gNewSound){
        if (speed <=10){
            llLoopSound(gSoundIdle,1.0);
            }
            else if (speed >=50){
                llLoopSound(gSoundAggressive,1.0);
            }
            else {
                llLoopSound(gSoundSlow,1.0);
            }    
    gOldSound = gNewSound;
    }
}

cornerFXR(){
    vector vel = llGetVel();
    float speed = llVecMag(vel);
    if (speed >50){
    llMessageLinked(LINK_SET, 0, "letsburnR", NULL_KEY);
        }
}

cornerFXL(){
    vector vel = llGetVel();
    float speed = llVecMag(vel);
    if (speed >50){
    llMessageLinked(LINK_SET, 0, "letsburnL", NULL_KEY);
        }
}

displaydigit(integer n, string d){
    list Facelist; //list depends on your mesh digital readout face number.
    integer i;       
    if(n==0) Facelist=[ 1,1,1,1,0,1,1 ]; //index @0 | 7 faces per digit
    if(n==1) Facelist=[ 0,0,1,0,0,1,0 ];
    if(n==2) Facelist=[ 1,1,0,1,1,1,0 ];
    if(n==3) Facelist=[ 1,1,1,0,1,1,0 ];
    if(n==4) Facelist=[ 0,0,1,0,1,1,1 ];
    if(n==5) Facelist=[ 1,1,1,0,1,0,1 ];
    if(n==6) Facelist=[ 0,1,1,1,1,0,1 ];
    if(n==7) Facelist=[ 1,0,1,0,0,1,0 ];
    if(n==8) Facelist=[ 1,1,1,1,1,1,1 ];
    if(n==9) Facelist=[ 1,0,1,0,1,1,1 ];
    
    integer l = llGetLinkNumber() != 0;   
    integer x = llGetNumberOfPrims() + l; 

    for (; l < x; ++l){
        if (llGetLinkName(l) == d){
            for (i=0;i<7;i++){
            llSetLinkPrimitiveParamsFast(l,[PRIM_COLOR,i,gFacecolor,llList2Float(Facelist,i)]);
            }
        }
    }
}

getdigit(integer gear){
string dOne;
string dTen;
string dHundred;
string dThousand;
integer i;
if (gear==0){
    gear=0;
    }else{
        gear=gear-1;
    }
    if (gear<10){
        dOne=(string)gear;
        dTen="0";
        dHundred="0";
        //dOneK="0"; // add your digits here
    }else if(gear<100){
        dOne=llGetSubString((string)gear,-1,-1);
        dTen=llGetSubString((string)gear,0,0);
        dHundred="0";
        //dOneK="0";
    }
    displaydigit((integer)dOne, "one");
    displaydigit((integer)dTen, "ten");
}

default {
    state_entry()
    {
        init_engine();
        state Ground;
    }
}

state Ground{

    state_entry(){
    }
    on_rez(integer param) {
        llResetScript();
        preload_sounds();
        init_PhysEng();
    }
    
    changed(integer change){
        if ((change & CHANGED_LINK) == CHANGED_LINK){
            gAgent = llAvatarOnSitTarget();
            if (gAgent != NULL_KEY){
                if( (gAgent != llGetOwner()) && (gDrivePermit == 1)){
                    llSay(0, gUrNotAllowedMessage);
                    llUnSit(gAgent);
                    llPlaySound(gSoundAlarm,1.0);
                    llPushObject(gAgent, <3,3,20>, ZERO_VECTOR, FALSE);
                }
                else {
                    llSetStatus(STATUS_PHYSICS, TRUE);
                    llSetStatus(STATUS_ROTATE_Y,TRUE);
                    llSetStatus(STATUS_ROTATE_Z,TRUE);
                    gOldAgent = gAgent;
                    init_PhysEng();
                    set_engine();
                    getdigit(2);
                    llRequestPermissions(gAgent, PERMISSION_TRIGGER_ANIMATION | PERMISSION_TAKE_CONTROLS | PERMISSION_CONTROL_CAMERA | PERMISSION_TRACK_CAMERA);
                    gRun = 1;
                }
            }
            else {
                llSetStatus(STATUS_PHYSICS, FALSE); //SHOULD THIS BE THE LAST THING YOU SET??
                gRun = 0;
                init_engine();
                getdigit(0);
                llTriggerSound(gSoundStop,1);
                llStopAnimation(gCurrentAnim);
                llPushObject(gAgent, <3,3,20>, ZERO_VECTOR, FALSE);
                llSetTimerEvent(0.0);
                llStopSound();
                llReleaseControls();
                llClearCameraParams();
                llSetCameraParams([CAMERA_ACTIVE, 0]);
                llSetText("",<0,0,0>,1.0);
                llMessageLinked(LINK_SET, 0, "Flame Off", NULL_KEY);
            }
        }
    }
    run_time_permissions(integer perm){
        if (perm) {
            gGear = 2; // GEAR#0 IS CREEP | GEAR#1 IS BURNOUT | GEAR#2 IS THE FIRST GEAR (LIST INDEX STARTS @ 0)
            llTakeControls(CONTROL_FWD | CONTROL_BACK | CONTROL_DOWN | CONTROL_UP | CONTROL_RIGHT | CONTROL_LEFT | CONTROL_ROT_RIGHT | CONTROL_ROT_LEFT, TRUE, FALSE);
            if (gCamFixed == 1) {
                init_fixedCam(0);
            }else{
                init_followCam();
            }
            llMessageLinked(LINK_SET, 0, "Flame On", NULL_KEY);
            llMessageLinked(LINK_SET, 0, "headlight", "0");
            llStartAnimation(gDrivingSlowLeftTurnAnim);
            gCurrentAnim=gDrivingSlowLeftTurnAnim;
            llTriggerSound(gSoundStartup,1.0);
            llSleep(1.5);
            enginesound();
        }
    }

    control(key id, integer held, integer change){
        if(gRun == 0){
            return;
        }
        integer reverse=1;
        vector vel = llGetVel();
        vector speedvec = llGetVel() / llGetRot();
        gSpeed = llVecMag(vel);
        gTurnRatio = llList2Float(gTurnRatioList,gGear);
        gAngularXratio = llList2Float(gAngularXratioList,gGear);
        gAngularYratio = llList2Float(gAngularYratioList,gGear);
        gAngularZratio = llList2Float(gAngularZratioList,gGear);

        if ((held & change & CONTROL_RIGHT) || ((gGear >= 11) && (held & CONTROL_RIGHT))){
            gGear=gGear+1;
            if (gGear < 0) gGear = 0;
            if (gGear > 11) gGear = 11;
            gearshift(gGear);
            getdigit(gGear);
        }

        if ((held & change & CONTROL_LEFT) || ((gGear >= 11) && (held & CONTROL_LEFT))){
            gGear=gGear-1;
            if (gGear < 0) gGear = 0;
            if (gGear > 11) gGear = 11;
            gearshift(gGear);
            getdigit(gGear);
        }

        if (held & CONTROL_FWD){
            if(gGear == 0) {
                llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <1.0, 2.0, 1.0>);
            }else{
                llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, gVLFT);
            }
            if(gGear == 1)  {
                llMessageLinked(LINK_SET, 0, "letsburn", NULL_KEY);
                llMessageLinked(LINK_SET, 0, "letsscreech", NULL_KEY);
                llMessageLinked(LINK_SET, 0, "pipeflame", NULL_KEY);
            }
            if(gGear == 2)  {
            llMessageLinked(LINK_SET, 0, "pipeflame_steady", NULL_KEY);
            }
            if(gGear == 3)  {
            llMessageLinked(LINK_SET, 0, "pipeflame_steady", NULL_KEY);
            }
            if(gGear == 4)  {
            llMessageLinked(LINK_SET, 0, "pipeflame_steady", NULL_KEY);
            }
            if(gGear == 5)  {
            llMessageLinked(LINK_SET, 0, "pipeflame_steady", NULL_KEY);
            llMessageLinked(LINK_SET, 0, "pipeflame", NULL_KEY);
            }
            if(gGear == 6)  {
            llMessageLinked(LINK_SET, 0, "pipeflame_steady", NULL_KEY);
            llMessageLinked(LINK_SET, 0, "pipeflame", NULL_KEY);
            }
            if(gGear == 7)  {
            llMessageLinked(LINK_SET, 0, "pipeflame_steady", NULL_KEY);
            llMessageLinked(LINK_SET, 0, "pipeflame_strong", NULL_KEY);
            llMessageLinked(LINK_SET, 0, "pipeflame", NULL_KEY);
            }
            if(gGear == 8)  {
            llMessageLinked(LINK_SET, 0, "pipeflame_steady", NULL_KEY);
            llMessageLinked(LINK_SET, 0, "pipeflame_strong", NULL_KEY);
            llMessageLinked(LINK_SET, 0, "pipeflame", NULL_KEY);
            }
            if(gGear == 9)  {
            llMessageLinked(LINK_SET, 0, "pipeflame_steady", NULL_KEY);
            llMessageLinked(LINK_SET, 0, "pipeflame_strong", NULL_KEY);
            llMessageLinked(LINK_SET, 0, "pipeflame", NULL_KEY);
            }
            if(gGear == 10) {
            llMessageLinked(LINK_SET, 0, "pipeflame_steady", NULL_KEY);
            llMessageLinked(LINK_SET, 0, "pipeflame_strong", NULL_KEY);
            llMessageLinked(LINK_SET, 0, "pipeflame", NULL_KEY);
            }
            if(gGear == 11) {
            llMessageLinked(LINK_SET, 0, "pipeflame_steady", NULL_KEY);
            llMessageLinked(LINK_SET, 0, "pipeflame_strong", NULL_KEY);
            llMessageLinked(LINK_SET, 0, "pipeflame", NULL_KEY);
            }
            powershift(gGear);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <gGearPower,0,0>);
            gMoving=1;
            reverse=1;
            gNewTireSpin = "ForwardSpin";
            llStartAnimation(gDrivingAnim);
            
        }

        if (held & CONTROL_BACK){
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <gReversePower,0,0>);
            llSetCameraParams([CAMERA_BEHINDNESS_ANGLE,-45.0]);
            llSetCameraParams([CAMERA_DISTANCE,8.0]);
            gTurnRatio = -2.0;
            reverse = -1;
            gNewTireSpin = "BackwardSpin";
            llMessageLinked(LINK_SET, 0, gTireSpin, NULL_KEY);
        }
         if (~held & change & CONTROL_FWD){
            //llSay(0,"CONTROL_FWD:Released");
            llMessageLinked(LINK_SET, 0, gTireSpin, NULL_KEY);             
            gNewTireSpin = "NoSpin";
            gNewTurnAngle = "NoTurn";
            //animation for idle here
            llStopAnimation(gCurrentAnim);
            llStartAnimation(gDrivingSlowLeftTurnAnim);
            gCurrentAnim=gDrivingSlowLeftTurnAnim;
        }
         if (~held & change & CONTROL_BACK){
            //llSay(0,"CONTROL_BACK:Released");
            llMessageLinked(LINK_SET, 0, gTireSpin, NULL_KEY);             
            gNewTireSpin = "NoSpin";
            gNewTurnAngle = "NoTurn";
        }
         if (~held & ~change & CONTROL_FWD){
            //llSay(0,"CONTROL_FWD:Inactive");
            llMessageLinked(LINK_SET, 0, gTireSpin, NULL_KEY);             
        }
         if (~held & ~change & CONTROL_BACK){
            //llSay(0,"CONTROL_BACK:Inactive");
            llMessageLinked(LINK_SET, 0, gTireSpin, NULL_KEY);             
        }
       
       showdata("Speed Vector:" + (string)speedvec + " Speed:" + (string)(gSpeed*2.23692912) + " mph");
       enginesound();
 
        vector AngularMotor;
        AngularMotor.y=0;
        if (held & (CONTROL_ROT_RIGHT)){
            if (gGear==3){
                llStopAnimation(gCurrentAnim);
                llStartAnimation(gDrivingSlowRightTurnAnim);
                gCurrentAnim=gDrivingSlowRightTurnAnim;
            }else if (gGear>3){
                llStopAnimation(gCurrentAnim);
                llStartAnimation(gDrivingFastRightTurnAnim);
                gCurrentAnim=gDrivingFastRightTurnAnim;
            }

            if(AngularMotor.x < gMaxLean){
            AngularMotor.x += gAngularXratio;
            }else{
            AngularMotor.x = gMaxLean;
            }
           // llSay(0,(string)AngularMotor.x);
            AngularMotor.z -= gAngularZratio;
            AngularMotor.y -= 0; 
            
            gNewTurnAngle = "RightTurn";

        }
         if (~held & change & CONTROL_ROT_RIGHT){
             //llSay(0,"right arrow key released");
             llStopAnimation(gCurrentAnim);
             llStartAnimation(gDrivingAnim);
             gCurrentAnim=gDrivingAnim;
        }

        if (held & (CONTROL_ROT_LEFT)){
            if (gGear==3){
                llStopAnimation(gCurrentAnim);
                llStartAnimation(gDrivingSlowLeftTurnAnim);
                gCurrentAnim=gDrivingSlowLeftTurnAnim;
            }else if (gGear>3){
                llStopAnimation(gCurrentAnim);
                llStartAnimation(gDrivingFastLeftTurnAnim);
                gCurrentAnim=gDrivingFastLeftTurnAnim;
            }

            if(AngularMotor.x >(gMaxLean*-1)){
            AngularMotor.x -= gAngularXratio;
            }else{
            AngularMotor.x = (gMaxLean*-1);
            }
            //llSay(0,(string)AngularMotor.x);
            AngularMotor.z += gAngularZratio;
            AngularMotor.y -= 0; 

            gNewTurnAngle = "LeftTurn";


         }
         if (~held & change & CONTROL_ROT_LEFT){
           // llSay(0,"left arrow key released");
            llStopAnimation(gCurrentAnim);
            llStartAnimation(gDrivingAnim);
            gCurrentAnim=gDrivingAnim;
        }

        if(held & CONTROL_UP) {
        AngularMotor.y -= ((gTurnRatio*gTurnMulti)*1);
        } else if (change & CONTROL_UP) {
        AngularMotor.y -= 0;
        }
        
        if(held & CONTROL_DOWN) {
        AngularMotor.y += ((gTurnRatio*gTurnMulti)*1);
        } else if (change & CONTROL_DOWN) {
        AngularMotor.y -= 0;
        }
         
        llSetVehicleVectorParam(VEHICLE_ANGULAR_MOTOR_DIRECTION, AngularMotor);
            if(gTcountL > 0){
                gTcountL--;
                //llSay(0,(string)gTcountL);
            }
            if(gTcountL == 1){
                cornerFXL();
            }
            if(gTcountR > 0){
                gTcountR--;
               // llSay(0,(string)gTcountR);
            }
            if(gTcountR == 1){
                cornerFXR();
            }
       
        if(gTurnCount > 0){
            gTurnCount--;
        }
        if(gTurnCount == 1){
            gNewTurnAngle = "NoTurn";
        }
        if(gTurnAngle != gNewTurnAngle){
            gTurnAngle = gNewTurnAngle;
            llMessageLinked(LINK_ALL_OTHERS, 0, gTurnAngle, NULL_KEY);
        }
        if(gTireSpin != gNewTireSpin){
            gTireSpin = gNewTireSpin;
            //llMessageLinked(LINK_ALL_OTHERS, 0, gTireSpin, NULL_KEY);
           llMessageLinked(LINK_SET, 0, gTireSpin, NULL_KEY);
        }

    }

    touch_start(integer total_number){
        if (gAgent != NULL_KEY){
            menu(llDetectedKey(0), "\nDriver's Menu.", MENU_MAIN);
        }
    }

    listen(integer channel,string name,key id,string message){
        if(llGetOwnerKey(id) == llGetOwner()){
            if (channel == menu_channel){
                llListenRemove(menu_handler);
                llSetTimerEvent(0);
                if (message == "Align"){
                    llSay(0, "Jet Ski is lined up...");
                    nearestpi();
                }
                else if (message == "PE-Default"){
                    llSay(0, "BulletSim is now set to 11 Steps per second | OpenSim Default");
                    gPhysEngStep=0;
                    init_PhysEng();
                }
                else if (message == "PE-iTEC"){
                    llSay(0, "BulletSim is now set to 20 Steps per second | ingen-lab Default");
                    gPhysEngStep=1;
                    init_PhysEng();
                }
                // else if (message == "Button"){
                // do something
                //}
            }
        }
    }


    link_message(integer sender, integer num, string str, key id){

        integer i = llGetLinkNumber() != 0;   // Start at zero (single prim) or 1 (two or more prims)
        integer x = llGetNumberOfPrims() + i; // [0, 1) or [1, llGetNumberOfPrims()]

        for (; i < x; ++i)
        {
        
            if (llGetLinkName(i) == "spin")
            {
                rotation rootRot = llGetRootRotation();
                vector rootPos = llGetRootPosition();
                
                list params = llGetLinkPrimitiveParams(i,[PRIM_POSITION,PRIM_ROT_LOCAL,PRIM_SIZE]);
                rotation childRot = llList2Rot(params,1);
                vector childPos = (llList2Vector(params,0)-rootPos)/rootRot;
                vector childSize = llList2Vector(params,2);

                    if(str == "ForwardSpin"){
                    llSetLinkPrimitiveParamsFast(i, [PRIM_OMEGA, <0.0,90.0,0.0>*DEG_TO_RAD*childRot, TWO_PI, 2.0]);
                    }else if (str == "BackwardSpin"){
                    llSetLinkPrimitiveParamsFast(i, [PRIM_OMEGA, <0.0,90.0,0.0>*DEG_TO_RAD*childRot, -TWO_PI, 1.0]);
                    }else if (str == "NoSpin"){
                    llSetLinkPrimitiveParamsFast(i, [PRIM_OMEGA, <0.0,00.0,0.0>*DEG_TO_RAD*childRot, 0, 1.0]);
                    }
            }else if (llGetLinkName(i) == "spin_y"){
                    if(str == "NoRotate"){
                    llSetLinkPrimitiveParamsFast(i, [PRIM_OMEGA, <0.0,00.0,0.0>*DEG_TO_RAD*0, 0, 0.987654]);
                    }else if (str == "SlowRotate"){
                    llSetLinkPrimitiveParamsFast(i, [PRIM_OMEGA, <0.0,90.0,0.0>*DEG_TO_RAD*1, TWO_PI*2, 0.987654]); 
                    }else if (str == "FastRotate"){
                    llSetLinkPrimitiveParamsFast(i, [PRIM_OMEGA, <0.0,90.0,0.0>*DEG_TO_RAD*1, TWO_PI*4, 0.987654]);
                    }
            }else if (llGetLinkName(i) == "spin_x"){
                    if(str == "NoRotate"){
                    llSetLinkPrimitiveParamsFast(i, [PRIM_OMEGA, <0.0,00.0,0.0>*DEG_TO_RAD*0, 0, 0.987654]);
                    }else if (str == "SlowRotate"){
                    llSetLinkPrimitiveParamsFast(i, [PRIM_OMEGA, <90.0,0.0,0.0>*DEG_TO_RAD*1, TWO_PI*2, 0.987654]); 
                    }else if (str == "FastRotate"){
                    llSetLinkPrimitiveParamsFast(i, [PRIM_OMEGA, <90.0,0.0,0.0>*DEG_TO_RAD*1, TWO_PI*4, 0.987654]);
                    }
            }else if (llGetLinkName(i) == "spin_z"){
                    if(str == "NoRotate"){
                    llSetLinkPrimitiveParamsFast(i, [PRIM_OMEGA, <0.0,00.0,0.0>*DEG_TO_RAD*0, 0, 0.987654]);
                    }else if (str == "SlowRotate"){
                    llSetLinkPrimitiveParamsFast(i, [PRIM_OMEGA, <0.0,0.0,90.0>*DEG_TO_RAD*1, TWO_PI*2, 0.987654]); 
                    }else if (str == "FastRotate"){
                    llSetLinkPrimitiveParamsFast(i, [PRIM_OMEGA, <0.0,0.0,90.0>*DEG_TO_RAD*1, TWO_PI*4, 0.987654]);
                    }
                }
            }
        }

    timer(){
        llListenRemove(menu_handler);
        if(gRun == 1){

        }else{
                llSetTimerEvent(0.0);
        }
    }
}