// ********************************************************************
// ***                       NOTE CARD GIVER                        ***
// ***                                            ***
// ***                                                              ***
// ***                                                  ***
// ********************************************************************
   
integer owneronly = 0;
key owner;

default
{
    state_entry()
    {
        owner = llGetOwner();        
    }

    touch_start(integer total_number)
    {
        integer i;
        for (i=0;i<total_number;i++)
        {
            key target = llDetectedKey(i);
        
            if ( (target != owner) && (owneronly == 1) )  // person clicking isn't owner and owneronly is set;
            {
                llInstantMessage(target,"Sorry, only the owner is allowed to get my contents.");
                return;
            }
            list inventory_types = [INVENTORY_LANDMARK,INVENTORY_NOTECARD];
            integer inventory_count = llGetListLength(inventory_types);
            integer j;
            integer k;
            integer type;
            integer typecount;
            string myname = llGetScriptName();
            string objectname;

            for (j=0; j<inventory_count;j++)
            {
                type = llList2Integer(inventory_types,j); // get the next inventory type from the list
                typecount = llGetInventoryNumber(type);  // how many of that kind of inventory is in the box?
                if (typecount > 0)
                {
                    for (k=0; k<typecount;k++)
                    {
                        objectname = llGetInventoryName(type,k);
                        if (objectname != myname)  // don't give self out so the user doesn't get fifty thousand copies.
                        {
                            llGiveInventory(target,objectname);
                        }
                    }
                }            
            }
        }
    }
}
