//=========================================================================================
// Bubble Jets for Super Hottub 1.1          ---    Siggy Romulus   Get_Toe() Scripts
//=========================================================================================
// Variables
//-----------------------------------------------------------------------------------------

integer JETS_CHANNEL = 55;              //Channel for jets to communicate on  
integer JETS_STATE = 0;                 // State of jets - 0 = off, 1 = on

key target;

//=========================================================================================
// Particle Systems
//-----------------------------------------------------------------------------------------


JetsOn()
{
    llParticleSystem([
    PSYS_PART_FLAGS, PSYS_PART_FOLLOW_SRC_MASK | PSYS_PART_FOLLOW_VELOCITY_MASK |
    PSYS_PART_TARGET_POS_MASK | PSYS_PART_INTERP_SCALE_MASK | PSYS_PART_INTERP_COLOR_MASK,

    PSYS_SRC_PATTERN,PSYS_SRC_PATTERN_ANGLE_CONE,

    PSYS_SRC_BURST_RATE,        0.06,
    PSYS_SRC_BURST_PART_COUNT,  8,
    PSYS_PART_MAX_AGE,          3.00,
    PSYS_SRC_ACCEL,             <0.00, 0.00, 0.05>,
    PSYS_SRC_BURST_RADIUS,      0.20,
    PSYS_SRC_BURST_SPEED_MIN,   .50,
    PSYS_SRC_BURST_SPEED_MAX,   1.00,
    PSYS_SRC_TARGET_KEY,        target,
    PSYS_SRC_INNERANGLE,        2.1,
    PSYS_SRC_OUTERANGLE,        0.44,
    PSYS_SRC_OMEGA,             <8.00, 1.60, 1.00>,
    PSYS_SRC_MAX_AGE,           0.0005,
    PSYS_PART_START_SCALE,      <0.03, 0.03, 0.03>,
    PSYS_PART_END_SCALE,        <.30, .30, .30>,
    PSYS_PART_START_COLOR,      <0.50, 0.50, 1.00>,
    PSYS_PART_END_COLOR,        <1.70, 1.70, 1.70>,
    PSYS_PART_START_ALPHA,      1.0,
    PSYS_PART_END_ALPHA,        .0,
    PSYS_SRC_TEXTURE,           "Water_droplet_01a"
    ]);
    
    llSay(JETS_CHANNEL, "JETS ON");
}
//---------------------------------------------------------------------------------------
JetsOff()
{
    llParticleSystem([]);
    llSay(JETS_CHANNEL, "JETS OFF");   
}
//=========================================================================================
default
{
    state_entry()
    {
        llListen(0,"","","");
        llListen(JETS_CHANNEL,"","","");

        llSay(JETS_CHANNEL,"get target");   // Request Key for the water object
        
        JetsOff();                          // Jets should start off
        JETS_STATE = 0;
        
    }

    listen(integer channel, string name, key id, string msg)
    {
                                                        // Water giving it's Key
        if (0 == llSubStringIndex(msg, "waterobject "))
        {
            target = (llGetSubString(msg, 12, -1));
        }
        
        else if (msg == "jets off")     // Direct commands to turn on / off
        {
            JetsOff();
            JETS_STATE = 0;   
        }
        else if (msg == "jets on")
        {
            llSay(JETS_CHANNEL, "get target");
            JetsOn();
            JETS_STATE = 1;
        }
        
        if (msg ==  "JETS CHANGE")          //switch command
        {
            if (JETS_STATE == 0)            // Jets are off
            {
                llSay(JETS_CHANNEL, "get target");      // request key from water
                JetsOn();
                JETS_STATE = 1;   
            }
            else if (JETS_STATE == 1)   // Jets are on
            {
                JetsOff();
                JETS_STATE = 0;   
            }
            
        }
    }
}
